<?php
    /**
    *
    * copyright (c) 2015-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * Classe che consente di gestire un file di log
    * 
    * Parametri: 
    * @dimensioneMassima inteso in kb, indica la dimensione massima dopo il quale il file viene svuotato
    * (il file viene )
    * @nomeFile il nome del file di log. Se non si trova nella stessa cartella bisogna specificare il percorso
    */

    class GestoreLog {
        private $nomeFile;
        private $ultimoLogInserito;
        private $fileStream;
        private $dimensioneMassima;
        
        function __construct($nomeFile, $dimensioneMassima) {
            $this->nomeFile  = $nomeFile;
            $this->dimensioneMassima = $dimensioneMassima;
            $this->ultimoLogInserito = "";
            $this->fileStream = fopen($this->nomeFile, "a+") or die("Impossibile aprire il file!");
        }
        
        function recuperaContenutoLog() {
            return fread($this->fileStream,filesize($this->nomeFile));
        }
        
        function scrivi($message) {
            $date = date("d/m/Y H:i");
            $this->ultimoLogInserito = "$date $message \n";
            fwrite($this->fileStream, $this->ultimoLogInserito);
        }
        
        function svuota() {
            $fileStream = fopen($this->nomeFile, "w") or die("Impossibile aprire il file!");
            fwrite($fileStream,"");
        }
        
        public function getUltimoLogInserito() {
            return $this->ultimoLogInserito;
        }

        function getNomeFile() {
            return $this->nomeFile;
        }

        function setNomeFile($nomeFile) {
            $this->nomeFile = $nomeFile;
        }
        
        function getDimensioneMassima() {
            return $this->dimensioneMassima;
        }

        function setDimensioneMassima($dimensioneMassima) {
            $this->dimensioneMassima = $dimensioneMassima;
        }
    }